<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Settings;
use App\Models\Message;
use App\User;
use App\Rules\MatchOldPassword;
use Hash;

use Carbon\Carbon;
use Spatie\Activitylog\Models\Activity;
class AdminController extends Controller
{
   public function index(){
    $data = User::select(\DB::raw("COUNT(*) as count"), \DB::raw("DAYNAME(created_at) as day_name"), \DB::raw("DAY(created_at) as day"))
        ->where('created_at', '>', Carbon::today()->subDay(6))
        ->groupBy('day_name','day')
        ->orderBy('day')
        ->get();

    // Fetch latest 10 messages
    $messages = Message::latest()->take(10)->get();

    $array[] = ['Name', 'Number'];
    foreach ($data as $key => $value) {
        $array[++$key] = [$value->day_name, $value->count];
    }

    return view('backend.index')->with('users', json_encode($array))->with('messages', $messages);
}


    public function profile(){
        $profile=Auth()->user();
        // return $profile;
        return view('backend.users.profile')->with('profile',$profile);
    }

    public function profileUpdate(Request $request,$id){
        // return $request->all();
        $user=User::findOrFail($id);
        $data=$request->all();
        if ($request->hasFile('image')) {
            $mainImage = $request->file('image');
            $mainFilename = time() . '.' . $mainImage->getClientOriginalExtension();
            $mainImage->move(public_path('backend/img'), $mainFilename);
            $user->photo = $mainFilename;
        }
        $status=$user->fill($data)->save();
        if($status){
            request()->session()->flash('success','Successfully updated your profile');
        }
        else{
            request()->session()->flash('error','Please try again!');
        }
        return redirect()->back();
    }

    public function settings(){
        $data=Settings::first();
        return view('backend.setting')->with('data',$data);
    }

    

   public function settingsUpdate(Request $request)
{
    // Validate the incoming request
    $request->validate([
        'name' => 'nullable|string',
        'copyright' => 'nullable|string',
        'news' => 'nullable|string',
        'email' => 'nullable|string',
        'mobile' => 'nullable|string',
        'pdf' => 'nullable|mimes:pdf|max:5120', // max 5MB
        'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg,webp',
    ]);

    // Get the first settings record
    $setting = Settings::first();

    // Update text fields
    $setting->fill($request->except('pdf', 'image')); // Exclude 'pdf' and 'site_logo' from fill

    // Handle PDF upload
    if ($request->hasFile('pdf')) {
        // Delete existing PDF if it exists
        if ($setting->pdf && file_exists(public_path($setting->pdf))) {
            unlink(public_path($setting->pdf));
        }

        // Store the new PDF
        $pdf = $request->file('pdf');
        $pdfName = time() . '_document.' . $pdf->getClientOriginalExtension();
        $pdf->move(public_path('backend/img/'), $pdfName);

        // Save the new PDF path
        $setting->pdf = '/backend/img/' . $pdfName;
    }

   // Handle site logo upload
if ($request->hasFile('image')) {
    // Delete existing site logo if it exists
    $oldImagePath = public_path($setting->image);
    if ($setting->image && is_file($oldImagePath) && file_exists($oldImagePath)) {
        unlink($oldImagePath);
    }

    // Store the new logo
    $logo = $request->file('image');
    $logoName = time() . '_logo.' . $logo->getClientOriginalExtension();
    $logo->move(public_path('backend/img/'), $logoName);

    // Save the new logo path
    $setting->image = 'backend/img/' . $logoName;
}


    // Save the updated settings record
    $status = $setting->save();

    // Return appropriate response based on whether save was successful
    if ($status) {
        return redirect()->route('admin')->with('success', 'Settings successfully updated');
    } else {
        return redirect()->back()->with('error', 'Please try again');
    }
}


    
    

    public function changePassword(){
        return view('backend.layouts.changePassword');
    }
    // public function changePasswordUpdate(Request $request)
    // {
    //     // Validate the request data
    //     $request->validate([
    //         'current_password' => ['required'],
    //         'new_password' => ['required', 'min:8'],
    //         'new_confirm_password' => ['required', 'same:new_password'],
    //         'question' => ['required', 'string'],
    //         'answer' => ['required', 'string'],
    //     ]);
    
    //     // Get the authenticated user
    //     $user = auth()->user();
    
    //     // Check if current password matches
    //     if (!Hash::check($request->current_password, $user->password)) {
    //         return back()->withErrors(['current_password' => 'The current password is incorrect.']);
    //     }
    
    //     // Update the user's password
    //     $user->update(['password' => Hash::make($request->new_password)]);
    
    //     // Redirect to the desired route with a success message
    //     return redirect()->route('admin')->with('success', 'Password successfully changed');
    // }

    public function changePasswordUpdate(Request $request)
{
    // Validate the request data
    $request->validate([
        'current_password' => ['required'],
        'new_password' => ['required', 'min:8', 'confirmed'], // Using 'confirmed' for password confirmation
        'question' => ['required', 'string'],
        'answer' => ['required', 'string'],
    ]);

    // Get the authenticated user
    $user = auth()->user();

    // Check if current password matches
    if (!Hash::check($request->current_password, $user->password)) {
        return back()->withErrors(['current_password' => 'The current password is incorrect.']);
    }

    // Update the user's password and other fields if necessary
    $user->update([
        'password' => Hash::make($request->new_password),
        'security_question' => $request->question, // Assuming there's a field in the DB for this
        'security_answer' => Hash::make($request->answer), // Hashing the answer for security
    ]);

    // Redirect to the desired route with a success message
    return redirect()->route('admin')->with('success', 'Password successfully changed');
}

    
    

    // Pie chart
    public function userPieChart(Request $request){
        // dd($request->all());
        $data = User::select(\DB::raw("COUNT(*) as count"), \DB::raw("DAYNAME(created_at) as day_name"), \DB::raw("DAY(created_at) as day"))
        ->where('created_at', '>', Carbon::today()->subDay(6))
        ->groupBy('day_name','day')
        ->orderBy('day')
        ->get();
     $array[] = ['Name', 'Number'];
     foreach($data as $key => $value)
     {
       $array[++$key] = [$value->day_name, $value->count];
     }
    //  return $data;
     return view('backend.index')->with('course', json_encode($array));
    }

    // public function activity(){
    //     return Activity::all();
    //     $activity= Activity::all();
    //     return view('backend.layouts.activity')->with('activities',$activity);
    // }
}
