<?php

namespace App\Http\Controllers;
use App\Models\Menu;
use App\Models\MenuContent;
use App\Models\Submenu;
use App\Models\SubContent;
use App\Models\Homebanner;
use App\Models\Testimonial;
use App\Models\Gallery;
use App\Models\Icons;
use App\Models\Section;
use App\Models\PopularClass;
use App\Models\Video;
use App\Models\Standard;
use App\Models\Value;
use App\Models\Media;
use App\Models\Facilitie;
use App\User;
use Auth;
use Session;
use Newsletter;
use DB;
use Hash;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\Notice;
use App\Models\NoticeCategory;
use App\Models\NewsCategory;
use App\Models\NewsItem;
use App\Models\University;
use App\Models\Course;



class FrontendController extends Controller
{
   
    public function index(Request $request){
        return redirect()->route($request->user()->role);
    }

    public function home(){
        $homebanners = Homebanner::where('status', '1')->orderBy('id', 'DESC')->limit(10)->get();
        $testimonials = Testimonial::where('status','1')->orderBy('id','DESC')->limit(10)->get();
        $gallery = Gallery::where('status','1')->orderBy('id','DESC')->limit(10)->get();
        $sections = Section::where('status','1')->orderBy('id','DESC')->limit(10)->get();
        $populars = PopularClass::where('status','1')->orderBy('id','DESC')->limit(10)->get();
        $values = Value::where('status','1')->orderBy('id','DESC')->limit(10)->get();
        $facilities = Facilitie::where('status','1')->orderBy('id','DESC')->limit(10)->get();
        $noticeCategories = \App\Models\NoticeCategory::with(['notices' => function($q) {
                                $q->latest()->take(3);
                            }])->get();
        $universities = \App\Models\University::orderBy('name')->get();
        $popularCourses = Course::where('popular', 1)->get();


        
        
        // Eager load submenus with menus
        $menus = Menu::all();
        // return $category;
        return view('frontend.index')
        ->with('homebanners', $homebanners)
        ->with('testimonials', $testimonials)
        ->with('gallery', $gallery)
        ->with('sections', $sections)
        ->with('populars', $populars)
        ->with('values', $values)
        ->with('menus', $menus)
        ->with('facilities', $facilities)
        ->with('noticeCategories', $noticeCategories)
        ->with('universities', $universities)
        ->with('popularCourses', $popularCourses);

    }

  
    public function handleRoute($identifier)
    {
      
        $menu = Menu::where('sluk', $identifier)->first();
        if ($menu) {
            $icons = Icons::where('status', 1)->orderBy('id', 'DESC')->limit(10)->get();
            $menus = Menu::all();
            $menucontent = MenuContent::where('sluk', $identifier)->first(); 
            $contents = MenuContent::where('sluk', $identifier)->get(); 
        
            return view('frontend.pages.writeup', compact('menus', 'menu', 'contents', 'menucontent', 'icons'));
        }
      
        $subcontent = SubContent::where('slug', $identifier)->firstOrFail();
        $subContents = SubContent::where('slug', $identifier)->get(); 
        $icons = Icons::where('status', 'active')->orderBy('id', 'DESC')->limit(10)->get();
        
        $menus = Menu::all();
        
        $submenus = Submenu::where('slug', $identifier)->get();
       
        return view('frontend.pages.subwriteup', compact('menus', 'submenus', 'subcontent', 'subContents', 'icons'));
    }

    // Login
    public function login(){
        return view('frontend.pages.login');
    }
    public function loginSubmit(Request $request){
        $data= $request->all();
        if(Auth::attempt(['email' => $data['email'], 'password' => $data['password'],'status'=>'active'])){
            Session::put('user',$data['email']);
            request()->session()->flash('success','Logged in successfully!');
            return redirect()->route('home');
        }
        else{
            request()->session()->flash('error','Invalid email and password pleas try again!');
            return redirect()->back();
        }
    }

    public function logout(){
        Session::forget('user');
        Auth::logout();
        request()->session()->flash('success','Logged out successfully');
        return back();
    }

    public function register(){
        return view('frontend.pages.register');
    }
    public function registerSubmit(Request $request){
        // return $request->all();
        $this->validate($request,[
            'name'=>'string|required|min:2',
            'email'=>'string|required|unique:users,email',
            'password'=>'required|min:6|confirmed',
            'question'=>'string|required',
            'answer'=>'string|required',
        ]);
        $data=$request->all();
        // dd($data);
        $check=$this->create($data);
        Session::put('user',$data['email']);
        if($check){
            request()->session()->flash('success','Registered successfully');
            return redirect()->route('home');
        }
        else{
            request()->session()->flash('error','Please try again!');
            return back();
        }
    }
    public function create(array $data){
        return User::create([
            'name'=>$data['name'],
            'email'=>$data['email'],
            'password'=>Hash::make($data['password']),
            'question'=>$data['question'],
            'answer'=>$data['answer'],
            'status'=>'active'
            ]);
    }
    // Reset password
    public function showResetForm(){
        return view('auth.passwords.old-reset');
    }


    public function subscribe(Request $request)
    {
        // Validate the email address
        $request->validate([
            'email' => 'required|email|unique:subscribes,email',
        ]);
    
        // Create a new Subscribe instance and set the email
        $subscribe = new Subscribe();
        $subscribe->email = $request->email;
    
        // Save the email and provide feedback
        if ($subscribe->save()) {
            session()->flash('success', 'Subscription has been added successfully');
        } else {
            session()->flash('error', 'Error occurred while adding subscription');
            return back();
        }
    
        // Redirect to the home route (or any other defined route)
        return redirect()->route('home');
    }

   public function someMethod()
    {
        $menus = Menu::all();
        $icons = Icons::where('status', 1)->orderBy('id', 'DESC')->limit(10)->get();
        $menu = Menu::where('sluk', 'contact')->first();
        $menucontents = Menucontent::where('sluk', 'contact')->first();
        $standards = Standard::all();

        if (!$menu || !$menucontents) {
            abort(404, 'Contact content not found');
        }

        return view('frontend.pages.contactus', compact('menus',  'menucontents', 'menu', 'icons','standards'));
    }

public function dynamic($identifier)
{
    $menu = Menu::where('sluk', $identifier)->firstOrFail();
    $menucontents = Menucontent::where('sluk', $identifier)->first();
    $menus = Menu::all();
    $standards = Standard::all();
    $icons = Icon::where('status', 1)->orderBy('id', 'DESC')->limit(10)->get();

    return view('frontend.pages.dynamic', compact('menu', 'menucontents', 'menus', 'standards', 'icons'));
}


public function gallery($identifier)
{
    $icons = Icons::where('status', 'active')->orderBy('id', 'DESC')->limit(10)->get();

    $menus = Menu::where('status', '1')
                ->with('submenus')
                ->orderBy('id', 'ASC')
                ->limit(10)
                ->get();

    $gallery = Gallery::where('status', '1')->orderBy('id', 'DESC')->limit(10)->get();

    $submenu = Submenu::where('slug', $identifier)->first(); // use `first()` to get a single result

    return view('frontend.pages.photo-gallery', compact('menus', 'icons', 'gallery', 'submenu'));
}


public function galleryDetail($slug)
    {
        $menus = Menu::where('status', '1')
            ->with('submenus')
            ->orderBy('id', 'ASC')
            ->limit(10)
            ->get();
    
        $gallery = Gallery::where('slug', $slug)->where('status', '1')->firstOrFail();
    
        return view('frontend.pages.gallery-details', compact('gallery', 'menus'));
    }
    

public function vGallery($identifier)
{
$icons = Icons::where('status', 'active')->orderBy('id', 'DESC')->limit(10)->get();
$menus = Menu::where('status', '1')->with('submenus') // Assuming 'submenus' is the correct relationship name
                     ->orderBy('id', 'ASC')
                     ->limit(10)
                     ->get();
$videos = Video::where('status', '1')->orderBy('id', 'DESC')->limit(10)->get();

$submenu = Submenu::where('slug', $identifier)->first(); // use `first()` to get a single result

return view('frontend.pages.video-gallery', compact('menus', 'videos','icons', 'submenu'));
}



public function media($identifier)
{
    $icons = Icons::where('status', 'active')->orderBy('id', 'DESC')->limit(10)->get();

    $menus = Menu::where('status', '1')
                ->with('submenus')
                ->orderBy('id', 'ASC')
                ->limit(10)
                ->get();

    $medias = Media::where('status', '1')->orderBy('id', 'DESC')->limit(10)->get();

    $submenu = Submenu::where('slug', $identifier)->first(); // use `first()` to get a single result

    return view('frontend.pages.media', compact('menus', 'icons', 'medias', 'submenu'));
}


public function mediaDetail($slug)
    {
        $menus = Menu::where('status', '1')
            ->with('submenus')
            ->orderBy('id', 'ASC')
            ->limit(10)
            ->get();
    
        $medias = Media::where('slug', $slug)->where('status', '1')->firstOrFail();
    
        return view('frontend.pages.media-details', compact('medias', 'menus'));
    }


    
public function resume($identifier)
{
    $icons = Icons::where('status', 'active')->orderBy('id', 'DESC')->limit(10)->get();

    $menus = Menu::where('status', '1')
                ->with('submenus')
                ->orderBy('id', 'ASC')
                ->limit(10)
                ->get();

    $submenu = Submenu::where('slug', $identifier)->first(); // use `first()` to get a single result

    return view('frontend.pages.upload-resume', compact('menus', 'icons',  'submenu'));
}

public function noticeCategoryWise($slug)
{
    $category = \App\Models\NoticeCategory::where('slug', $slug)->firstOrFail();
    $notices = \App\Models\Notice::where('notice_category_id', $category->id)
                ->orderBy('date', 'desc')
                ->get();

    $menus = Menu::all();
    $icons = Icons::where('status', 1)->orderBy('id', 'DESC')->limit(10)->get();

    return view('frontend.pages.notice-list', compact('category', 'notices', 'menus', 'icons'));
}


public function news()
{
    $newsCategories = NewsCategory::with(['newsItems' => function($q) {
        $q->latest()->limit(6); // Limit for homepage
    }])->get();

    return view('frontend.news.index', compact('newsCategories'));
}

public function showNews($slug)
{
    $news = NewsItem::where('slug', $slug)->firstOrFail();
    return view('frontend.news.show', compact('news'));
}


public function showUniversity($slug)
{
    $university = University::where('slug', $slug)->firstOrFail();
    $universities = University::orderBy('name')->get();

    return view('frontend.university', compact('university', 'universities'));
}


public function popularCourses()
{
    // Fetch courses that are marked as popular
    $popularCourses = Course::where('popular', 1)->get();

    return view('frontend.pages.popular-courses', compact('popularCourses'));
}

}
