<?php

namespace App\Http\Controllers;

use App\Models\Gallery;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

class GalleryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $gallerys=Gallery::latest()->paginate(10);
        return view('backend.gallery.index', compact('gallerys'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('backend.gallery.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
{
    // Validate the uploaded files (array of images)
    $request->validate([
        'title' => 'nullable|string',
        'images' => 'required|array', // Ensure it's an array of files
        'images.*' => 'image|mimes:jpg,png,jpeg,gif|max:2048', // Validate each file individually
        'photo' => 'nullable|image|mimes:jpg,png,jpeg,gif|max:2048', // Optional photo field
    ]);

    // Handle the single photo upload (if exists)
    $imagePath = null;
    if ($request->hasFile('photo')) {
        $photo = $request->file('photo');
        $extension = $photo->getClientOriginalExtension();
        $imageName = time() . uniqid() . '.' . $extension; // Combine time and uniqid to prevent name collision
        $photo->move(public_path('admin/img/'), $imageName);
        $imagePath = 'admin/img/' . $imageName; // Store the path of the uploaded photo
    }

    // Handle multiple images upload
    $uploadedImages = [];
    if ($request->hasFile('images')) {
        foreach ($request->file('images') as $file) {
            $filename = time() . uniqid() . '_' . $file->getClientOriginalName(); // Use uniqid to prevent name collision
            $file->move(public_path('admin/img/'), $filename); // Save to public folder
            $uploadedImages[] = $filename; // Store only filenames
        }
    }

    // Convert array of uploaded images to a comma-separated string
    $imagePaths = implode(',', $uploadedImages);

    // Save image path to the database (Gallery model)
    Gallery::create([
        'title' => $request->title,
        'slug' => Str::slug($request->title),
        'image' => $imagePaths,  // Save the image paths as a comma-separated string
        'status' => $request->status ? 1 : 0, // Handle the status value
        'photo' => $imagePath,  // Save the single photo path (optional)
    ]);

    // Redirect back with success message
    return redirect()->route('backend.gallery.index')->with('success', 'Gallery created successfully.');
}

    

    /**
     * Display the specified resource.
     */
    public function show(Gallery $gallery)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Gallery $gallery)
    {
        return view('backend.gallery.edit', compact('gallery'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Gallery $gallery)
    {
        $request->validate([
            'title' => 'nullable|string',
            'images' => 'nullable|array',
            'images.*' => 'image|mimes:jpg,png,jpeg,gif|max:2048',
            'photo' => 'nullable|image|mimes:jpg,png,jpeg,gif|max:2048',
            'status' => 'nullable|boolean',
        ]);
    
        $data = [
            'title' => $request->title,
            'slug' => Str::slug($request->title),
            'status' => $request->status ? 1 : 0,
        ];
    
        // Handle single photo
        if ($request->hasFile('photo')) {
            if ($gallery->photo && file_exists(public_path($gallery->photo))) {
                unlink(public_path($gallery->photo));
            }
            $photo = $request->file('photo');
            $imageName = time() . uniqid() . '.' . $photo->getClientOriginalExtension();
            $photo->move(public_path('admin/img'), $imageName);
            $data['photo'] = 'admin/img/' . $imageName;
        }
    
        // Handle multiple images
        if ($request->hasFile('images')) {
            if ($gallery->image) {
                foreach (explode(',', $gallery->image) as $oldImage) {
                    $oldImagePath = public_path('admin/img/' . trim($oldImage));
                    if (file_exists($oldImagePath)) {
                        unlink($oldImagePath);
                    }
                }
            }
    
            $uploadedImages = [];
            foreach ($request->file('images') as $file) {
                $filename = time() . uniqid() . '_' . $file->getClientOriginalName();
                $file->move(public_path('admin/img'), $filename);
                $uploadedImages[] = $filename;
            }
    
            $data['image'] = implode(',', $uploadedImages);
        }
    
        $gallery->update($data);
    
        return redirect()->route('backend.gallery.index')->with('success', 'Gallery updated successfully.');
    }
    


    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Gallery $gallery)
    {
        // Delete image from public directory
        if ($gallery->image && file_exists(public_path($gallery->image))) {
            unlink(public_path($gallery->image));
        }

        $gallery->delete();
        return redirect()->route('backend.gallery.index')->with('success', 'Gallery deleted successfully.');
    }
}
