<?php

namespace App\Http\Controllers;

use App\Models\Homebanner;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

class HomebannerController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index() {
        $homebanners = Homebanner::latest()->paginate(10);
        return view('backend.homebanners.index', compact('homebanners'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('backend.homebanners.create');
    }

    /**
     * Store a newly created resource in storage.
     */

public function store(Request $request) {
    $request->validate([
        'image' => 'nullable|image|mimes:jpg,png,jpeg,gif',
        'link' => 'nullable|url'
    ]);

    $imagePath = null;
    if ($request->hasFile('image')) {
        $image = $request->file('image');
        $extension = $image->getClientOriginalExtension();
        $imageName = time() . '.' . $extension;
        $image->move(public_path('admin/img/'), $imageName);
        $imagePath = 'admin/img/' . $imageName;
    }


   HomeBanner::create([
    'title' => $request->title,
    'description' => $request->description,
    'image' => $imagePath,
    'link' => $request->link,
    'status' => $request->status ? 1 : 0,
]);


    return redirect()->route('backend.homebanners.index')->with('success', 'Home Banner created successfully.');
}


    /**
     * Display the specified resource.
     */
    public function show(Homebanner $homebanner)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Homebanner $homebanner)
    {
        return view('backend.homebanners.edit', compact('homebanner'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, homebanner $homebanner) {
        $request->validate([
            'image' => 'nullable|image|mimes:jpg,jpeg,png,gif',
            'link' => 'nullable|url'
        ]);

        if ($request->hasFile('image')) {
            // Delete old image if exists
            if ($homebanner->image && file_exists(public_path($homebanner->image))) {
                unlink(public_path($homebanner->image));
            }

            // Upload new image
            $image = $request->file('image');
            $imageName = time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('admin/img'), $imageName);
            $homebanner->image = 'admin/img/' . $imageName; // Save relative path
        }

       $homebanner->update([
    'title' => $request->title,
    'description' => $request->description,
    'link' => $request->link,
    'status' => $request->status ? 1 : 0,
]);

        return redirect()->route('backend.homebanners.index')->with('success', 'Home Banner updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(homebanner $homebanner) {
        // Delete image from public directory
        if ($homebanner->image && file_exists(public_path($homebanner->image))) {
            unlink(public_path($homebanner->image));
        }

        $homebanner->delete();
        return redirect()->route('backend.homebanners.index')->with('success', 'Home Banner deleted successfully.');
    }
}
