<?php

namespace App\Http\Controllers;

use App\Models\Icons;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

class IconsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $icons= Icons::latest()->paginate(10);
        return view('backend.icons.index',compact('icons'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('backend.icons.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
{
    $request->validate([
        'title' => 'nullable|string',
        'url' => 'nullable|string',
        'status' => 'nullable' // Optional: validate status if expected
    ]);

    \App\Models\Icons::create([
        'title' => $request->title,
        'slug' => Str::slug($request->title),
        'url' => $request->url,
        'status' => $request->status ? 1 : 0,
    ]);

    return redirect()->route('backend.icons.index')->with('success', 'Icons created successfully.');
}


    /**
     * Display the specified resource.
     */
    public function show(Icons $icons)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Icons $icons)
    {
        return view('backend.icons.edit',compact('icons'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Icons $icons)
{
    $request->validate([
        'title' => 'nullable|string',
        'url' => 'nullable|string',
        'status' => 'nullable'
    ]);

    $icons->update([
        'title' => $request->title,
        'slug' => Str::slug($request->title),
        'url' => $request->url,
        'status' => $request->status ? 1 : 0,
    ]);

    return redirect()->route('backend.icons.index')->with('success', 'Icons updated successfully.');
}


    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Icons $icons)
    {
         // Delete image from public directory
         if ($icons->image && file_exists(public_path($icons->image))) {
            unlink(public_path($icons->image));
        }

        $icons->delete();
        return redirect()->route('backend.icons.index')->with('success', 'Icons deleted successfully.');
    }
}
