<?php

namespace App\Http\Controllers;

use App\Models\Media;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

class MediaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $medias=Media::latest()->paginate(10);
        return view('backend.medias.index', compact('medias'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
         return view('backend.medias.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // Validate the uploaded files (array of images)
    $request->validate([
        'title' => 'nullable|string',
        'images' => 'required|array', // Ensure it's an array of files
        'images.*' => 'image|mimes:jpg,png,jpeg,gif', // Validate each file individually
        'photo' => 'nullable|image|mimes:jpg,png,jpeg,gif', // Optional photo field
    ]);

    // Handle the single photo upload (if exists)
    $imagePath = null;
    if ($request->hasFile('photo')) {
        $photo = $request->file('photo');
        $extension = $photo->getClientOriginalExtension();
        $imageName = time() . uniqid() . '.' . $extension; // Combine time and uniqid to prevent name collision
        $photo->move(public_path('admin/img/'), $imageName);
        $imagePath = 'admin/img/' . $imageName; // Store the path of the uploaded photo
    }

    // Handle multiple images upload
    $uploadedImages = [];
    if ($request->hasFile('images')) {
        foreach ($request->file('images') as $file) {
            $filename = time() . uniqid() . '_' . $file->getClientOriginalName(); // Use uniqid to prevent name collision
            $file->move(public_path('admin/img/'), $filename); // Save to public folder
            $uploadedImages[] = $filename; // Store only filenames
        }
    }

    // Convert array of uploaded images to a comma-separated string
    $imagePaths = implode(',', $uploadedImages);

    // Save image path to the database (Media model)
    Media::create([
        'title' => $request->title,
        'slug' => Str::slug($request->title),
        'image' => $imagePaths,  // Save the image paths as a comma-separated string
        'status' => $request->status ? 1 : 0, // Handle the status value
        'photo' => $imagePath,  // Save the single photo path (optional)
    ]);

    // Redirect back with success message
    return redirect()->route('backend.medias.index')->with('success', 'Media created successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Media  $media
     * @return \Illuminate\Http\Response
     */
    public function show(media $media)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Media  $media
     * @return \Illuminate\Http\Response
     */
    public function edit(media $media)
    {
         return view('backend.medias.edit', compact('media'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Media  $media
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Media $media)
    {
        $request->validate([
            'title' => 'nullable|string',
            'images' => 'nullable|array',
            'images.*' => 'image|mimes:jpg,png,jpeg,gif',
            'photo' => 'nullable|image|mimes:jpg,png,jpeg,gif',
            'status' => 'nullable|boolean',
        ]);
    
        $data = [
            'title' => $request->title,
            'slug' => Str::slug($request->title),
            'status' => $request->status ? 1 : 0,
        ];
    
        // Handle single photo
        if ($request->hasFile('photo')) {
            if ($media->photo && file_exists(public_path($media->photo))) {
                unlink(public_path($media->photo));
            }
            $photo = $request->file('photo');
            $imageName = time() . uniqid() . '.' . $photo->getClientOriginalExtension();
            $photo->move(public_path('admin/img'), $imageName);
            $data['photo'] = 'admin/img/' . $imageName;
        }
    
        // Handle multiple images
        if ($request->hasFile('images')) {
            if ($media->image) {
                foreach (explode(',', $media->image) as $oldImage) {
                    $oldImagePath = public_path('admin/img/' . trim($oldImage));
                    if (file_exists($oldImagePath)) {
                        unlink($oldImagePath);
                    }
                }
            }
    
            $uploadedImages = [];
            foreach ($request->file('images') as $file) {
                $filename = time() . uniqid() . '_' . $file->getClientOriginalName();
                $file->move(public_path('admin/img'), $filename);
                $uploadedImages[] = $filename;
            }
    
            $data['image'] = implode(',', $uploadedImages);
        }
    
        $media->update($data);
    
        return redirect()->route('backend.medias.index')->with('success', 'Media updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Media  $media
     * @return \Illuminate\Http\Response
     */
    public function destroy(Media $media)
    {
         // Delete image from public directory
        if ($media->image && file_exists(public_path($media->image))) {
            unlink(public_path($media->image));
        }

        $media->delete();
        return redirect()->route('backend.medias.index')->with('success', 'Media deleted successfully.');
    }
}
