<?php

namespace App\Http\Controllers;


use App\Models\Menu;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

class MenuController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $menus = Menu::latest()->paginate(10);
        return view('backend.menus.index',compact('menus'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('backend.menus.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'title'=>'nullable|string',
            'url'=>'nullable|url',
            'metatitle'=>'nullable|string',
            'description'=>'nullable|string',
            'keywords'=>'nullable|string',
            'image' => 'nullable|image|mimes:jpg,png,jpeg,gif|max:2048',
        ]);

        $imagePath = null;
    if ($request->hasFile('image')) {
        $image = $request->file('image');
        $extension = $image->getClientOriginalExtension();
        $imageName = time() . '.' . $extension;
        $image->move(public_path('admin/img/'), $imageName);
        $imagePath = 'admin/img/' . $imageName;
    }

        Menu::create([
            'title' => $request->title,
            'sluk' => Str::slug($request->title),
            'url' => $request->url,
            'image' => $imagePath,
            'metatitle' => $request->metatitle,
            'description' => $request->description,
            'keywords' => $request->keywords,
            'status' => $request->status ? 1 : 0,
        ]);
    
        return redirect()->route('backend.menus.index')->with('success', 'Menu created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(Menu $menu)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Menu $menu)
    {
        return view('backend.menus.edit',compact('menu'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Menu $menu)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'url'=>'nullable|url',
            'metatitle'=>'nullable|string',
            'description'=>'nullable|string',
            'keywords'=>'nullable|string',
            'image' => 'nullable|image|mimes:jpg,png,jpeg,gif|max:2048',
        ]);
        if ($request->hasFile('image')) {
            // Delete old image if exists
            if ($menu->image && file_exists(public_path($menu->image))) {
                unlink(public_path($menu->image));
            }

            // Upload new image
            $image = $request->file('image');
            $imageName = time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('admin/img'), $imageName);
            $menu->image = 'admin/img/' . $imageName; // Save relative path
        }

        $menu->update([
            'title' => $request->title,
            'sluk' => Str::slug($request->title),
            'url' => $request->url,
            'metatitle' => $request->metatitle,
            'description' => $request->description,
            'keywords' => $request->keywords,
            'status' => $request->status ? 1 : 0,
        ]);

        return redirect()->route('backend.menus.index')->with('success', 'Menus updated successfully.');

    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Menu $menu)
    {
        if ($menu->image && file_exists(public_path($menu->image))) {
            unlink(public_path($menu->image));
        }

        $menu->delete();
        return redirect()->route('backend.menus.index')->with('success', 'Menu deleted successfully.');
    }
}
