<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\NewsCategory;
use Illuminate\Support\Str;

class NewsCategoryController extends Controller
{
    public function index()
    {
        $categories = NewsCategory::latest()->get();
        return view('backend.news_categories.index', compact('categories'));
    }

    public function create()
    {
        return view('backend.news_categories.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255|unique:news_categories,name',
        ]);

        NewsCategory::create([
            'name' => $request->name,
            'slug' => Str::slug($request->name)
        ]);

        return redirect()->route('backend.news-categories.index')->with('success','Category created successfully.');
    }

    public function edit($id)
    {
        $category = NewsCategory::findOrFail($id);
        return view('backend.news_categories.edit', compact('category'));
    }

    public function update(Request $request, $id)
    {
        $category = NewsCategory::findOrFail($id);

        $request->validate([
            'name' => 'required|string|max:255|unique:news_categories,name,'.$id,
        ]);

        $category->update([
            'name' => $request->name,
            'slug' => Str::slug($request->name)
        ]);

        return redirect()->route('backend.news-categories.index')->with('success','Category updated successfully.');
    }

    public function destroy($id)
    {
        $category = NewsCategory::findOrFail($id);
        $category->delete();
        return redirect()->route('backend.news-categories.index')->with('success','Category deleted successfully.');
    }
}
