<?php

namespace App\Http\Controllers;

use Session;
use App\Setting;
use Illuminate\Http\Request;

class SettingController extends Controller
{
    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Setting  $setting
     * @return \Illuminate\Http\Response
     */
    public function edit(Setting $setting)
    {
        $setting = Setting::first();
        
        return view('admin.setting.edit', compact('setting'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Setting  $setting
     * @return \Illuminate\Http\Response
     */
//     public function update(Request $request)
//     {
//         // dd($request->all());
//         $this->validate($request, [
//             'name' => 'required',
//             'copyright' => 'required',
//         ]);

//         $setting = Setting::first();
//         $setting->update($request->all());

//         if($request->hasFile('site_logo')){
//             $image = $request->site_logo;
//             $image_new_name = time() . '.' . $image->getClientOriginalExtension();
//             $image->move('storage/setting/', $image_new_name);
//             $setting->site_logo = '/storage/setting/' . $image_new_name;
//             $setting->save();
//         }

//         Session::flash('success', 'Setting updated successfully');
//         return redirect()->back();
//     }

 public function update(Request $request)
    {
        $request->validate([
            'name' => 'nullable|string',
            'copyright' => 'nullable|string',
            'summary' => 'nullable|string',
            'pdf' => 'nullable|mimes:pdf|max:5120', // max 5MB
            'site_logo' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg,webp',
        ]);
    
        $setting = Setting::first();
    
        // Update text fields
        $setting->fill($request->except('image', 'site_logo'));
    
       if ($request->hasFile('pdf')) {
    // Delete existing PDF if it exists
    if ($setting->pdf && file_exists(public_path($setting->pdf))) {
        unlink(public_path($setting->pdf));
    }

    $pdf = $request->file('pdf');
    $pdfName = time() . '_document.' . $pdf->getClientOriginalExtension();
    $pdf->move(public_path('storage/setting/'), $pdfName);

    // Save path
    $setting->pdf = '/storage/setting/' . $pdfName;
}

    
        // Handle site logo upload
        if ($request->hasFile('site_logo')) {
            if ($setting->site_logo && file_exists(public_path($setting->site_logo))) {
                unlink(public_path($setting->site_logo));
            }
    
            $logo = $request->file('site_logo');
            $logoName = time() . '_logo.' . $logo->getClientOriginalExtension();
            $logo->move(public_path('storage/setting/'), $logoName);
            $setting->site_logo = '/storage/setting/' . $logoName;
        }
    
        $setting->save();
    
        Session::flash('success', 'Setting updated successfully');
        return redirect()->back();
    }

 }
