<?php

namespace App\Http\Controllers;

use App\Models\Standard;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

class StandardController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        // Fetch paginated results
    $standards = Standard::paginate(10); // Adjust the number of items per page as needed

    // Pass paginated results to the view
    return view('backend.standards.index', compact('standards'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('backend.standards.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
         // Corrected validation syntax
         $request->validate([
            'title' => 'nullable|string',
            'status' => 'nullable|in:1,0'
        ]);
    
        // Create a new instance of GalleryCategory
        $standard = new Standard();
        $standard->title = $request->title;
    
        // Generate a slug from the title
        $standard->slug = Str::slug($request->title); // Fixed Str::slug() usage
    
        $standard->status = $request->status;
    
        // Save the gallery category and handle success/error messages
        if ($standard->save()) {
            session()->flash('success', 'Standard has been added successfully');
        } else {
            session()->flash('error', 'Error adding Standard');
        }
    
        // Return the correct view (or consider redirecting back to the form)
        return redirect()->route('backend.standards.index'); // Assuming you have a named route
    }

    /**
     * Display the specified resource.
     */
    public function show(Standard $standard)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
{
    $standards = Standard::findOrFail($id); // returns a single model
    return view('backend.standards.edit', compact('standards'));
}


    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
         // Retrieve the standard or fail if not found
         $standard = Standard::findOrFail($id);
    
         // Corrected validation syntax
         $request->validate([
             'title' => 'nullable|string',
             'status' => 'nullable|in:1,0'
         ]);
     
         // Update the standard properties
         $standard->title = $request->title;
     
         // Generate a slug from the title
         $standard->slug = Str::slug($request->title); // Ensure Str is imported
     
         $standard->status = $request->status;
     
         // Save the standard and handle success/error messages
         if ($standard->save()) {
             session()->flash('success', 'Standard has been updated successfully');
         } else {
             session()->flash('error', 'Error updating Standard');
         }
     
         // Return the correct view (or consider redirecting back to the form)
         return redirect()->route('backend.standards.index');

    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $standards=Standard::findorFail($id);
        $status=$standards->delete();
        // Save the gallery category and handle success/error messages
    if ($standards->delete()) {
        session()->flash('success', 'Standard has been delete successfully');
    } else {
        session()->flash('error', 'Error deleting standard');
    }

    // Return the correct view (or consider redirecting back to the form)
    return redirect()->route('backend.standards.index'); // Assuming you have a named route
    }
}
