<?php

namespace App\Http\Controllers;

use App\Models\Value;
use Illuminate\Http\Request;

class ValueController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $values = Value::latest()->paginate(10);
        return view('backend.values.index', compact('values'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('backend.values.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'title'=>'nullable|string',
            'description'=>'nullable|string',
            'image'=>'nullable|image|mimes:jpg,png,jpeg,gif',
        ]);

        $imagePath = null;
    if ($request->hasFile('image')) {
        $image = $request->file('image');
        $extension = $image->getClientOriginalExtension();
        $imageName = time() . '.' . $extension;
        $image->move(public_path('admin/img/'), $imageName);
        $imagePath = 'admin/img/' . $imageName;
    }

    Value::create([
            'title'=> $request->title,
            'description'=> $request->description,
            'image'=> $imagePath,
            'status'=> $request->status ? 1 : 0 ,
        ]);

        return redirect()->route('backend.values.index')->with('success','Value Created successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(Value $value)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Value $value)
    {
        return view('backend.values.edit',compact('value'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Value $value)
    {
        $request->validate([
            'title'=>'nullable|string',
            'description'=>'nullable|string',
            'image'=>'nullable|image|mimes:jpg,png,jpeg,gif',
        ]);

        if ($request->hasFile('image')) {
            // Delete old image if exists
            if ($value->image && file_exists(public_path($value->image))) {
                unlink(public_path($value->image));
            }

            // Upload new image
            $image = $request->file('image');
            $imageName = time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('admin/img'), $imageName);
            $value->image = 'admin/img/' . $imageName; // Save relative path
        }

        $value->update([
            'title'=> $request->title,
            'description'=> $request->description,
            'status'=> $request->status ? 1 : 0 ,
        ]);

        return redirect()->route('backend.values.index')->with('success','Value Updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Value $value)
    {
        if($value->image && file_exists(public_path($value->image))){
            unlink(public_path($value->image));
        }
        $value->delete();
        return redirect()->route('backend.values.index')->with('succes','Value deleted successfully');
    }
}
