<?php

namespace App\Http\Controllers;

use App\Models\Video;
use Illuminate\Http\Request;

class VideoController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $videos=Video::latest()->paginate(10);
        return view('backend.videos.index', compact('videos'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('backend.videos.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
{
    $request->validate([
        'url' => 'nullable|string',
        'status' => 'nullable' // Optional: validate status if expected
    ]);

    \App\Models\Video::create([
        'url' => $request->url,
        'status' => $request->status ? 1 : 0,
    ]);

    return redirect()->route('backend.videos.index')->with('success', 'Video created successfully.');
}

    /**
     * Display the specified resource.
     */
    public function show(Video $video)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Video $video)
    {
        return view('backend.videos.edit',compact('video'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Video $video)
    {
        $request->validate([
            'url' => 'nullable|string',
            'status' => 'nullable'
        ]);
    
        $video->update([
            'url' => $request->url,
            'status' => $request->status ? 1 : 0,
        ]);
    
        return redirect()->route('backend.videos.index')->with('success', 'Video updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Video $video)
    {
         // Delete image from public directory
         if ($video->image && file_exists(public_path($video->image))) {
            unlink(public_path($video->image));
        }

        $video->delete();
        return redirect()->route('backend.videos.index')->with('success', 'Videos deleted successfully.');
    }
}
