<?php

namespace App\Providers;

use Illuminate\Support\Str;
use App\Models\Menu;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\View;
use App\Models\University;
use App\Models\Course;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
public function boot()
{
    // Force HTTPS in production
    if (app()->environment('production')) {
        URL::forceScheme('https');
    }

    // Set default string length for older MySQL versions
    Schema::defaultStringLength(191);

    // Add a custom macro to the Str facade
    Str::macro('sluk', function ($string) {
        return Str::slug($string);
    });

    Str::macro('slum', function ($string) {
        return Str::slug($string);
    });

    // ✅ SAFETY CHECK before querying
    if (Schema::hasTable('menus')) {
        try {
            $menus = \App\Models\Menu::all();
            View::share('menus', $menus);
        } catch (\Exception $e) {
            // Ignore any exceptions during artisan commands
        }
    }

       View::composer('*', function ($view) {
        $view->with('universities', University::all());
        
    });

        View::share('navCourses', Course::select('title','cslug')->get());

}

}
