<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNewsItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
      Schema::create('news_items', function (Blueprint $table) {
    $table->id();
    $table->foreignId('news_category_id')->constrained('news_categories')->onDelete('cascade');
    $table->string('title');
    $table->string('short_description')->nullable();
    $table->longText('description');
    $table->string('image')->nullable();
    $table->date('published_at')->nullable();
    $table->timestamps();
});

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('news_items');
    }
}
