<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCoursesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
   public function up()
{
    Schema::create('courses', function (Blueprint $table) {
        $table->id();
        $table->foreignId('university_id')->constrained()->onDelete('cascade');
        $table->string('title');
        $table->string('deliverable')->nullable();
        $table->string('duration')->nullable(); // e.g. "4 years (8 semesters)"
        $table->string('eligibility_criteria')->nullable();
        $table->string('subjects')->nullable(); // e.g. "Physics, Maths, Chemistry/IT/CS"
        $table->string('color')->nullable(); // for card styling (like maroon, yellow)
        $table->timestamps();
    });
}


    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('courses');
    }
}
