<?php

// database/migrations/xxxx_xx_xx_create_course_descriptions_table.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCourseDescriptionsTable extends Migration
{
    public function up()
    {
        Schema::create('course_descriptions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('course_id')->constrained()->onDelete('cascade');
            $table->string('title');
            $table->text('description');
            $table->text('key_points'); // Store key points as a comma-separated string
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('course_descriptions');
    }
}
